% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_deregister_container_instance}
\alias{ecs_deregister_container_instance}
\title{Deregister Container Instance}
\usage{
ecs_deregister_container_instance(
  cluster = NULL,
  containerInstance = NULL,
  force = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance...}

\item{containerInstance}{Character. The container instance ID or full ARN of the container instance to deregister.}

\item{force}{Logical.   Forces the deregistration of the container instance.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Deregister Container Instance
}
\section{cluster}{

The short name or full Amazon Resource Name
(ARN) of the cluster that hosts the container instance to deregister. If
you do not specify a cluster, the default cluster is
assumed.
}

\section{containerInstance}{

The container instance ID or full ARN of
the container instance to deregister. The ARN contains the \code{arn:aws:ecs}
namespace, followed by the Region of the container instance, the AWS
account ID of the container instance owner, the \code{container-instance}
namespace, and then the container instance ID. For example,
\code{arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID}.
}

\section{force}{


Forces the deregistration of the container instance. If you have tasks
running on the container instance when you deregister it with the
\code{force} option, these tasks remain running until you terminate the
instance or the tasks stop through some other means, but they are
orphaned (no longer monitored or accounted for by Amazon ECS). If an
orphaned task on your container instance is part of an Amazon ECS
service, then the service scheduler starts another copy of that task, on
a different container instance if possible.

Any containers in orphaned service tasks that are registered with a
Classic Load Balancer or an Application Load Balancer target group are
deregistered. They begin connection draining according to the settings
on the load balancer or target group.
}

