% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_replace_transit_gateway_route}
\alias{ec2_replace_transit_gateway_route}
\title{Replace Transit Gateway Route}
\usage{
ec2_replace_transit_gateway_route(
  DestinationCidrBlock,
  TransitGatewayRouteTableId,
  TransitGatewayAttachmentId = NULL,
  Blackhole = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{DestinationCidrBlock}{Character. The CIDR range used for the destination match.}

\item{TransitGatewayRouteTableId}{Character. The ID of the route table.}

\item{TransitGatewayAttachmentId}{Character. The ID of the attachment.[optional]}

\item{Blackhole}{Logical. Indicates whether traffic matching this route is to be dropped.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Replaces the specified route in the specified
transit gateway route table.
}
\section{DestinationCidrBlock}{

The CIDR range used for the
destination match. Routing decisions are based on the most specific
match.
}

\section{TransitGatewayRouteTableId}{

The ID of the route
table.
}

\section{TransitGatewayAttachmentId}{

The ID of the
attachment.
}

\section{Blackhole}{

Indicates whether traffic matching this
route is to be dropped.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

