% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_replace_route}
\alias{ec2_replace_route}
\title{Replace Route}
\usage{
ec2_replace_route(
  RouteTableId,
  DestinationCidrBlock = NULL,
  DestinationIpv6CidrBlock = NULL,
  DestinationPrefixListId = NULL,
  DryRun = NULL,
  VpcEndpointId = NULL,
  EgressOnlyInternetGatewayId = NULL,
  GatewayId = NULL,
  InstanceId = NULL,
  LocalTarget = NULL,
  NatGatewayId = NULL,
  TransitGatewayId = NULL,
  LocalGatewayId = NULL,
  CarrierGatewayId = NULL,
  NetworkInterfaceId = NULL,
  VpcPeeringConnectionId = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{RouteTableId}{Character. The ID of the route table.}

\item{DestinationCidrBlock}{Character. The IPv4 CIDR address block used for the destination match.[optional]}

\item{DestinationIpv6CidrBlock}{Character. The IPv6 CIDR address block used for the destination match.[optional]}

\item{DestinationPrefixListId}{Character. The ID of the prefix list for the route.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{VpcEndpointId}{Character. The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.[optional]}

\item{EgressOnlyInternetGatewayId}{Character. [IPv6 traffic only] The ID of an egress-only internet gateway.[optional]}

\item{GatewayId}{Character. The ID of an internet gateway or virtual private gateway.[optional]}

\item{InstanceId}{Character. The ID of a NAT instance in your VPC.[optional]}

\item{LocalTarget}{Logical. Specifies whether to reset the local route to its default target (\code{local}).[optional]}

\item{NatGatewayId}{Character. [IPv4 traffic only] The ID of a NAT gateway.[optional]}

\item{TransitGatewayId}{Character. The ID of a transit gateway.[optional]}

\item{LocalGatewayId}{Character. The ID of the local gateway.[optional]}

\item{CarrierGatewayId}{Character. [IPv4 traffic only] The ID of a carrier gateway.[optional]}

\item{NetworkInterfaceId}{Character. The ID of a network interface.[optional]}

\item{VpcPeeringConnectionId}{Character. The ID of a VPC peering connection.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Replace Route
}
\section{RouteTableId}{

The ID of the route
table.
}

\section{DestinationCidrBlock}{

The IPv4 CIDR address block used for the
destination match. The value that you provide must match the CIDR of an
existing route in the table.
}

\section{DestinationIpv6CidrBlock}{

The IPv6 CIDR address
block used for the destination match. The value that you provide must
match the CIDR of an existing route in the
table.
}

\section{DestinationPrefixListId}{

The ID of the prefix list for the
route.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{VpcEndpointId}{

The ID of a VPC endpoint.
Supported for Gateway Load Balancer endpoints
only.
}

\section{EgressOnlyInternetGatewayId}{

[IPv6 traffic only] The ID of an egress-only
internet gateway.
}

\section{GatewayId}{

The ID of an internet gateway or
virtual private gateway.
}

\section{InstanceId}{

The ID of a NAT instance in
your VPC.
}

\section{LocalTarget}{

Specifies whether to reset the local route
to its default target (\code{local}).
}

\section{NatGatewayId}{

[IPv4 traffic
only] The ID of a NAT gateway.
}

\section{TransitGatewayId}{

The ID of a transit
gateway.
}

\section{LocalGatewayId}{

The ID of the local
gateway.
}

\section{CarrierGatewayId}{

[IPv4 traffic only] The ID of a carrier
gateway.
}

\section{NetworkInterfaceId}{

The ID of a network
interface.
}

\section{VpcPeeringConnectionId}{

The ID of a VPC peering
connection.
}

