% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_spot_fleet_request}
\alias{ec2_modify_spot_fleet_request}
\title{Modify Spot Fleet Request}
\usage{
ec2_modify_spot_fleet_request(
  SpotFleetRequestId,
  ExcessCapacityTerminationPolicy = NULL,
  LaunchTemplateConfig = NULL,
  TargetCapacity = NULL,
  OnDemandTargetCapacity = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{SpotFleetRequestId}{Character. The ID of the Spot Fleet request.}

\item{ExcessCapacityTerminationPolicy}{Character. Indicates whether running Spot Instances should be terminated if the target capacity of the Spot...[optional]}

\item{LaunchTemplateConfig}{List. The launch template and overrides.[optional]}

\item{TargetCapacity}{Integer. The size of the fleet.[optional]}

\item{OnDemandTargetCapacity}{Integer. The number of On-Demand Instances in the fleet.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modify Spot Fleet Request
}
\section{SpotFleetRequestId}{

The ID of the Spot Fleet
request.
}

\section{ExcessCapacityTerminationPolicy}{

Indicates whether running Spot Instances
should be terminated if the target capacity of the Spot Fleet request is
decreased below the current size of the Spot
Fleet.
}

\section{LaunchTemplateConfig}{

The launch template and overrides. You can
only use this parameter if you specified a launch template
(\code{LaunchTemplateConfigs}) in your Spot Fleet request. If you specified
\code{LaunchSpecifications} in your Spot Fleet request, then omit this
parameter.
}

\section{TargetCapacity}{

The size of the
fleet.
}

\section{OnDemandTargetCapacity}{

The number of On-Demand Instances in the
fleet.
}

