% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_export_image}
\alias{ec2_export_image}
\title{Export Image}
\usage{
ec2_export_image(
  DiskImageFormat,
  ImageId,
  S3ExportLocation,
  ClientToken = NULL,
  Description = NULL,
  DryRun = NULL,
  RoleName = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{DiskImageFormat}{Character. The disk image format.}

\item{ImageId}{Character. The ID of the image.}

\item{S3ExportLocation}{Object. Information about the destination Amazon S3 bucket.}

\item{ClientToken}{Character. Token to enable idempotency for export image requests.[optional]}

\item{Description}{Character. A description of the image being exported. The maximum length is 255 characters.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{RoleName}{Character. The name of the role that grants VM Import/Export permission to export images to your Amazon S3 bucket....[optional]}

\item{TagSpecification}{List. The tags to apply to the export image task during creation.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Exports an Amazon Machine Image (AMI) to a
VM file. For more information, see \href{https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html}{Exporting a VM Directory from an Amazon Machine Image (AMI)}
in the \emph{VM Import/Export User Guide}.
}
\section{DiskImageFormat}{

The disk image
format.
}

\section{ImageId}{

The ID of the
image.
}

\section{S3ExportLocation}{

Information about the destination Amazon S3
bucket. The bucket must exist and grant WRITE and READ_ACP permissions
to the AWS account
vm-import-export\@amazon.com.
}

\section{ClientToken}{

Token to enable
idempotency for export image requests.
}

\section{Description}{

A description
of the image being exported. The maximum length is 255
characters.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{RoleName}{

The name of the role that
grants VM Import/Export permission to export images to your Amazon S3
bucket. If this parameter is not specified, the default role is named
\'vmimport\'.
}

\section{TagSpecification}{

The tags to apply to the export image
task during creation.
}

