% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_copy_snapshot}
\alias{ec2_copy_snapshot}
\title{Copy Snapshot}
\usage{
ec2_copy_snapshot(
  SourceRegion,
  SourceSnapshotId,
  Description = NULL,
  DestinationOutpostArn = NULL,
  DestinationRegion = NULL,
  Encrypted = NULL,
  KmsKeyId = NULL,
  PresignedUrl = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{SourceRegion}{Character. The ID of the Region that contains the snapshot to be copied.}

\item{SourceSnapshotId}{Character. The ID of the EBS snapshot to copy.}

\item{Description}{Character. A description for the EBS snapshot.[optional]}

\item{DestinationOutpostArn}{Character.   The Amazon Resource Name (ARN) of the Outpost to which to copy the snapshot.[optional]}

\item{DestinationRegion}{Character.   The destination Region to use in the \code{PresignedUrl} parameter of a snapshot copy operation.[optional]}

\item{Encrypted}{Logical. To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption...[optional]}

\item{KmsKeyId}{Character.   The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for...[optional]}

\item{PresignedUrl}{Character.   When you copy an encrypted source snapshot using the Amazon EC2 Query API, you must supply a pre-signed...[optional]}

\item{TagSpecification}{List. The tags to apply to the new snapshot.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Copy Snapshot
}
\section{SourceRegion}{

The ID of the Region that
contains the snapshot to be copied.
}

\section{SourceSnapshotId}{

The ID of the
EBS snapshot to copy.
}

\section{Description}{

A description for the EBS
snapshot.
}

\section{DestinationOutpostArn}{


The Amazon Resource Name (ARN) of the Outpost to which to copy the
snapshot. Only specify this parameter when copying a snapshot from an
AWS Region to an Outpost. The snapshot must be in the Region for the
destination Outpost. You cannot copy a snapshot from an Outpost to a
Region, from one Outpost to another, or within the same Outpost.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-snapshots}{Copying snapshots from an AWS Region to an Outpost}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{DestinationRegion}{


The destination Region to use in the \code{PresignedUrl} parameter of a
snapshot copy operation. This parameter is only valid for specifying the
destination Region in a \code{PresignedUrl} parameter, where it is required.

The snapshot copy is sent to the regional endpoint that you sent the
HTTP request to (for example, \verb{ec2.us-east-1.amazonaws.com}). With the
AWS CLI, this is specified using the \code{--region} parameter or the default
Region in your AWS configuration file.
}

\section{Encrypted}{

To encrypt a copy of an unencrypted snapshot if
encryption by default is not enabled, enable encryption using this
parameter. Otherwise, omit this parameter. Encrypted snapshots are
encrypted, even if you omit this parameter and encryption by default is
not enabled. You cannot set this parameter to false. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{KmsKeyId}{


The identifier of the AWS Key Management Service (AWS KMS) customer
master key (CMK) to use for Amazon EBS encryption. If this parameter is
not specified, your AWS managed CMK for EBS is used. If \code{KmsKeyId} is
specified, the encrypted state must be \code{true}.

You can specify the CMK using any of the following:
\itemize{
\item Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
\item Key alias. For example, alias/ExampleAlias.
\item Key ARN. For example,
arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
\item Alias ARN. For example,
arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
}

AWS authenticates the CMK asynchronously. Therefore, if you specify an
ID, alias, or ARN that is not valid, the action can appear to complete,
but eventually fails.
}

\section{PresignedUrl}{


When you copy an encrypted source snapshot using the Amazon EC2 Query
API, you must supply a pre-signed URL. This parameter is optional for
unencrypted snapshots. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html}{Query requests}.

The \code{PresignedUrl} should use the snapshot source endpoint, the
\code{CopySnapshot} action, and include the \code{SourceRegion},
\code{SourceSnapshotId}, and \code{DestinationRegion} parameters. The
\code{PresignedUrl} must be signed using AWS Signature Version 4. Because EBS
snapshots are stored in Amazon S3, the signing algorithm for this
parameter uses the same logic that is described in \href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests: Using Query Parameters (AWS Signature Version 4)}
in the \emph{Amazon Simple Storage Service API Reference}. An invalid or
improperly signed \code{PresignedUrl} will cause the copy operation to fail
asynchronously, and the snapshot will move to an \code{error} state.
}

\section{TagSpecification}{

The tags to apply to the new
snapshot.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

