% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_search_transit_gateway_multicast_groups}
\alias{ec2_search_transit_gateway_multicast_groups}
\title{Search Transit Gateway Multicast Groups}
\usage{
ec2_search_transit_gateway_multicast_groups(
  TransitGatewayMulticastDomainId = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayMulticastDomainId}{String. The ID of the transit gateway multicast domain.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Searches one or more transit gateway
multicast groups and returns the group membership
information.
}
\section{TransitGatewayMulticastDomainId}{

The ID of the transit
gateway multicast domain.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{group-ip-address} - The IP address of the transit gateway multicast
group.
\item \code{is-group-member} - The resource is a group member. Valid values are
\code{true} \| \code{false}.
\item \code{is-group-source} - The resource is a group source. Valid values are
\code{true} \| \code{false}.
\item \code{member-type} - The member type. Valid values are \code{igmp} \|
\code{static}.
\item \code{resource-id} - The ID of the resource.
\item \code{resource-type} - The type of resource. Valid values are \code{vpc} \|
\code{vpn} \| \code{direct-connect-gateway} \| \code{tgw-peering}.
\item \code{source-type} - The source type. Valid values are \code{igmp} \|
\code{static}.
\item \code{state} - The state of the subnet association. Valid values are
\code{associated} \| \code{associated} \| \code{disassociated} \| \code{disassociating}.
\item \code{subnet-id} - The ID of the subnet.
\item \code{transit-gateway-attachment-id} - The id of the transit gateway
attachment.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

