% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_run_scheduled_instances}
\alias{ec2_run_scheduled_instances}
\title{Run Scheduled Instances}
\usage{
ec2_run_scheduled_instances(
  LaunchSpecification,
  ScheduledInstanceId,
  ClientToken = NULL,
  DryRun = NULL,
  InstanceCount = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{LaunchSpecification}{Object. The launch specification.}

\item{ScheduledInstanceId}{String. The Scheduled Instance ID.}

\item{ClientToken}{String. Unique, case-sensitive identifier that ensures the idempotency of the request.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{InstanceCount}{Integer.   The number of instances.  Default: 1  [optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Run Scheduled Instances
}
\section{LaunchSpecification}{

The launch specification. You must match the
instance type, Availability Zone, network, and platform of the schedule
that you purchased.
}

\section{ScheduledInstanceId}{

The Scheduled Instance
ID.
}

\section{ClientToken}{

Unique, case-sensitive identifier that ensures
the idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{InstanceCount}{


The number of instances.

Default: 1
}

