% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpc_endpoint_service_permissions}
\alias{ec2_modify_vpc_endpoint_service_permissions}
\title{Modify Vpc Endpoint Service Permissions}
\usage{
ec2_modify_vpc_endpoint_service_permissions(
  ServiceId,
  DryRun = NULL,
  AddAllowedPrincipals = NULL,
  RemoveAllowedPrincipals = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ServiceId}{String. The ID of the service.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{AddAllowedPrincipals}{List. The Amazon Resource Names (ARN) of one or more principals.[optional]}

\item{RemoveAllowedPrincipals}{List. The Amazon Resource Names (ARN) of one or more principals.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Vpc Endpoint Service Permissions
}
\section{ServiceId}{

The ID of the
service.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{AddAllowedPrincipals}{

The Amazon Resource Names
(ARN) of one or more principals. Permissions are granted to the
principals in this list. To grant permissions to all principals, specify
an asterisk (\*).
}

\section{RemoveAllowedPrincipals}{

The Amazon Resource Names (ARN) of
one or more principals. Permissions are revoked for principals in this
list.
}

