% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_get_associated_ipv6_pool_cidrs}
\alias{ec2_get_associated_ipv6_pool_cidrs}
\title{Get Associated Ipv6 Pool Cidrs}
\usage{
ec2_get_associated_ipv6_pool_cidrs(
  PoolId,
  NextToken = NULL,
  MaxResults = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{PoolId}{String. The ID of the IPv6 address pool.}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Gets information about the IPv6 CIDR block
associations for a specified IPv6 address pool.
}
\section{PoolId}{

The ID of the IPv6 address
pool.
}

\section{MaxResults}{

The maximum number of results to return
with a single call. To retrieve the remaining results, make another call
with the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

