% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_disassociate_enclave_certificate_iam_role}
\alias{ec2_disassociate_enclave_certificate_iam_role}
\title{Disassociate Enclave Certificate Iam Role}
\usage{
ec2_disassociate_enclave_certificate_iam_role(
  CertificateArn = NULL,
  RoleArn = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{CertificateArn}{String. The ARN of the ACM certificate from which to disassociate the IAM role.[optional]}

\item{RoleArn}{String. The ARN of the IAM role to disassociate.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Disassociates an IAM role from an AWS Certificate
Manager (ACM) certificate. Disassociating an IAM role from an ACM
certificate removes the Amazon S3 object that contains the certificate,
certificate chain, and encrypted private key from the Amazon S3 bucket.
It also revokes the IAM role\'s permission to use the AWS Key Management
Service (KMS) customer master key (CMK) used to encrypt the private key.
This effectively revokes the role\'s permission to use the certificate.
}
\section{CertificateArn}{

The ARN of the ACM
certificate from which to disassociate the IAM
role.
}

\section{RoleArn}{

The ARN of the IAM role to
disassociate.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

