% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_snapshots}
\alias{ec2_describe_snapshots}
\title{Describe Snapshots}
\usage{
ec2_describe_snapshots(
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  Owner = NULL,
  RestorableBy = NULL,
  SnapshotId = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of snapshot results returned by \code{DescribeSnapshots} in paginated output.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{Owner}{List. Scopes the results to snapshots with the specified owners.[optional]}

\item{RestorableBy}{List. The IDs of the AWS accounts that can create volumes from the snapshot.[optional]}

\item{SnapshotId}{List.   The snapshot IDs.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Snapshots
}
\section{Filter}{


The filters.
\itemize{
\item \code{description} - A description of the snapshot.
\item \code{encrypted} - Indicates whether the snapshot is encrypted (\code{true} \|
\code{false})
\item \code{owner-alias} - The owner alias, from an Amazon-maintained list
(\code{amazon}). This is not the user-configured AWS account alias set
using the IAM console. We recommend that you use the related
parameter instead of this filter.
\item \code{owner-id} - The AWS account ID of the owner. We recommend that you
use the related parameter instead of this filter.
\item \code{progress} - The progress of the snapshot, as a percentage (for
example, 80\\%).
\item \code{snapshot-id} - The snapshot ID.
\item \code{start-time} - The time stamp when the snapshot was initiated.
\item \code{status} - The status of the snapshot (\code{pending} \| \code{completed} \|
\code{error}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{volume-id} - The ID of the volume the snapshot is for.
\item \code{volume-size} - The size of the volume, in GiB.
}
}

\section{MaxResults}{

The maximum number of snapshot results returned by
\code{DescribeSnapshots} in paginated output. When this parameter is used,
\code{DescribeSnapshots} only returns \code{MaxResults} results in a single page
along with a \code{NextToken} response element. The remaining results of the
initial request can be seen by sending another \code{DescribeSnapshots}
request with the returned \code{NextToken} value. This value can be between 5
and 1,000; if \code{MaxResults} is given a value larger than 1,000, only
1,000 results are returned. If this parameter is not used, then
\code{DescribeSnapshots} returns all results. You cannot specify this
parameter and the snapshot IDs parameter in the same
request.
}

\section{Owner}{

Scopes the results to snapshots with the
specified owners. You can specify a combination of AWS account IDs,
\code{self}, and \code{amazon}.
}

\section{RestorableBy}{

The IDs of the AWS accounts
that can create volumes from the snapshot.
}

\section{SnapshotId}{


The snapshot IDs.

Default: Describes the snapshots for which you have create volume
permissions.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

