% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_public_ipv4_pools}
\alias{ec2_describe_public_ipv4_pools}
\title{Describe Public Ipv4 Pools}
\usage{
ec2_describe_public_ipv4_pools(
  PoolId = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  Filter = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{PoolId}{List. The IDs of the address pools.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the specified IPv4 address
pools.
}
\section{PoolId}{

The IDs of the address
pools.
}

\section{MaxResults}{

The maximum number of results to return
with a single call. To retrieve the remaining results, make another call
with the returned \code{nextToken} value.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}
}

