% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_launch_template_version}
\alias{ec2_create_launch_template_version}
\title{Create Launch Template Version}
\usage{
ec2_create_launch_template_version(
  LaunchTemplateData,
  DryRun = NULL,
  ClientToken = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  SourceVersion = NULL,
  VersionDescription = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{LaunchTemplateData}{Object. The information for the launch template.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{String.   Unique, case-sensitive identifier you provide to ensure the idempotency of the request.[optional]}

\item{LaunchTemplateId}{String. The ID of the launch template.[optional]}

\item{LaunchTemplateName}{String. The name of the launch template.[optional]}

\item{SourceVersion}{String. The version number of the launch template version on which to base the new version.[optional]}

\item{VersionDescription}{String. A description for the version of the launch template.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Launch Template Version
}
\section{LaunchTemplateData}{

The information for the launch
template.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{


Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.

Constraint: Maximum 128 ASCII characters.
}

\section{LaunchTemplateId}{

The ID of the launch template. You must specify
either the launch template ID or launch template name in the
request.
}

\section{LaunchTemplateName}{

The name of the launch template. You must
specify either the launch template ID or launch template name in the
request.
}

\section{SourceVersion}{

The version number of the launch template
version on which to base the new version. The new version inherits the
same launch parameters as the source version, except for parameters that
you specify in \code{LaunchTemplateData}. Snapshots applied to the block
device mapping are ignored when creating a new version unless they are
explicitly included.
}

\section{VersionDescription}{

A description for the version
of the launch template.
}

