% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_confirm_product_instance}
\alias{ec2_confirm_product_instance}
\title{Confirm Product Instance}
\usage{
ec2_confirm_product_instance(
  InstanceId,
  ProductCode,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceId}{String. The ID of the instance.}

\item{ProductCode}{String. The product code. This must be a product code that you own.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Determines whether a product code is associated
with an instance. This action can only be used by the owner of the
product code. It is useful when a product code owner must verify whether
another user\'s instance is eligible for
support.
}
\section{InstanceId}{

The ID of the
instance.
}

\section{ProductCode}{

The product code. This must be a product
code that you own.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

