% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_bundle_instance}
\alias{ec2_bundle_instance}
\title{Bundle Instance}
\usage{
ec2_bundle_instance(
  InstanceId,
  Storage,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceId}{String.   The ID of the instance to bundle.  Type: String  Default: None  Required: Yes}

\item{Storage}{Object. The bucket in which to store the AMI.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Bundle Instance
}
\section{InstanceId}{


The ID of the instance to bundle.

Type: String

Default: None

Required: Yes
}

\section{Storage}{

The bucket in which to store the AMI. You can
specify a bucket that you already own or a new bucket that Amazon EC2
creates on your behalf. If you specify a bucket that belongs to someone
else, Amazon EC2 returns an error.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

