% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_medical_phi.R
\name{detect_medical_phi}
\alias{detect_medical_phi}
\title{Detect Protected Health Information (PHI) in a source medical text}
\usage{
detect_medical_phi(text, language = "en", ...)
}
\arguments{
\item{text}{A character string containing a text to entities analyze, or a character vector to perform analysis separately for each element.}

\item{language}{A character string containing a two-letter language code. Currently only \dQuote{en} is supported.}

\item{\dots}{Additional arguments passed to \code{\link{comprehendHTTP}}.}
}
\value{
A data frame
}
\description{
Detect Protected Health Information (PHI) in a source medical text
}
\examples{
\dontrun{
  # simple example
  medical_detect_phi("Mrs. Smith comes in today complaining of shortness of breath.")
  
  txt <-c("Mrs. Smith comes in today.",
          "She is complaining of shortnesss of breath.")
  medical_detect_phi(txt)
}
}
