% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{somInit}
\alias{somInit}
\title{Initialize SOM prototypes}
\usage{
somInit(traindat, nrows, ncols, method = c("pca.sample", "pca", "random"))
}
\arguments{
\item{traindat}{Matrix of training data, that will also be used to train the
SOM.}

\item{nrows}{Number of rows on the map.}

\item{ncols}{Number of columns on the map.}

\item{method}{Method used, see Details. "pca" or "random"}
}
\value{
A matrix of prototype coordinates.
}
\description{
Prototypes are the artificial points in data space that are used to cluster
observations: each observation is assigned to the cluster of its closest
prototype. In self-organizing maps, each cell of the map has its own
prototype, and training is performed by iteratively adjusting the prototypes.
This function creates an initial guess for the prototypes of a SOM grid, to
be used as the \code{init} argument to the \code{kohonen::som} function (see example).
}
\details{
The default method "pca.sample" takes as prototypes the observations
  that are closest to the nodes of a 2d grid placed along the first two
  components of a PCA. The "pca" method uses the nodes instead of the
  observations. The "random" method samples random observations.
}
\examples{
dat <- iris[, c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")]
### Scale training data
dat <- scale(dat)
## Train SOM
### Initialization (PCA grid)
init <- somInit(dat, 4, 4)
the.som <- kohonen::som(dat, grid = kohonen::somgrid(4, 4, 'hexagonal'), 
                        rlen = 100, alpha = c(0.05, 0.01), 
                        radius = c(2.65,-2.65), init = init, 
                        dist.fcts = 'sumofsquares')
}
