% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transcriptome_id_from_logic_operation.R
\name{get_transcriptome_id_from_logic_operation}
\alias{get_transcriptome_id_from_logic_operation}
\title{Get transcriptome from logic operations}
\usage{
get_transcriptome_id_from_logic_operation(
  logic_operation,
  seed_id = FALSE,
  transcriptome_seq = FALSE,
  transcriptome_pos = FALSE
)
}
\arguments{
\item{logic_operation}{List of logical functions from the following set:
"equals", "exclusive or", "not-or", "and-not", "or", "orn-not", "and",
"not-and", "not".}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer
values, or a logical value. This integer is used for starting the
pseudo-random number generator that represents the environment experiencing a
digital organism. If a logical value is used, TRUE returns data found in all
environments and FALSE (by default) returns only distinct data regardless of
the seed.}

\item{transcriptome_seq}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{transcriptome_pos}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}
}
\value{
Data frame. Columns: "seed_id" (optional), "transcriptome_id",
"transcriptome_seq" (optional), "transcriptome_pos" (optional)
}
\description{
Get the transcriptome of a digital organism that executes a
specific combination of logic operations for a list of seeds used for
starting the pseudo-random number generator (i.e., a set of environments).
}
\examples{

# Single logic operation
get_transcriptome_id_from_logic_operation(logic_operation = "not")

# More than one logic operation
get_transcriptome_id_from_logic_operation(
  logic_operation = c("not", "and"),
  transcriptome_seq = TRUE
)

# At seed_1 and seed_2
get_transcriptome_id_from_logic_operation(
  logic_operation = c("not", "and"),
  seed_id = c(1,2),
  transcriptome_seq = TRUE,
  transcriptome_pos = TRUE
)

}
