% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avfintools.R
\name{RSI}
\alias{RSI}
\title{Relative Strength Index}
\usage{
RSI(df, periods, current = FALSE, pricechange = NULL, hideprints = TRUE)
}
\arguments{
\item{df}{Dataframe with price data}

\item{periods}{Calculation Period}

\item{current}{If one wants to input the latest price point before data updates, RSI uses the percentage return at the end of the market hours}

\item{pricechange}{Input in percentage}

\item{hideprints}{If TRUE, hides printouts from the current message}
}
\value{
Returns a vector of RSI calculations in dataframe format. If current = TRUE, returns the most recent RSI.
}
\description{
Returns the Relative Strength Index with adjustable periods
}
\examples{
RSI(SPY15, 14)
RSI(tail(SPYdaily,200), 14, current = TRUE, pricechange = 1.3)
}
