% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{formats}
\alias{formats}
\alias{av_encoders}
\alias{av_decoders}
\alias{av_filters}
\alias{av_muxers}
\alias{av_demuxers}
\title{AV Formats}
\usage{
av_encoders()

av_decoders()

av_filters()

av_muxers()

av_demuxers()
}
\description{
List supported filters, codecs and container formats.
}
\details{
Encoders and decoders convert between raw video/audio frames and compressed stream
data for storage or transfer. However such a compressed data stream by itself does
not constitute a valid video format yet. Muxers are needed to interleave one or more
audio/video/subtitle streams, along with timestamps, metadata, etc, into a proper
file format, such as mp4 or mkv.

Conversely, demuxers are needed to read a file format into the seperate data streams
for subsequent decoding into raw audio/video frames. Most operating systems natively
support demuxing and decoding common formats and codecs, needed to play those videos.
However for encoding and muxing such videos, ffmpeg must have been configured with
specific external libraries for a given codec or format.
}
\seealso{
Other av: \code{\link{capturing}}, \code{\link{demo}},
  \code{\link{encoding}}, \code{\link{info}},
  \code{\link{logging}}
}
\concept{av}
