% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_forecast.R
\name{stsm_forecast}
\alias{stsm_forecast}
\title{Kalman Filter and Forecast}
\usage{
stsm_forecast(
  model,
  y,
  n.ahead = 0,
  freq = NULL,
  exo = NULL,
  exo.fc = NULL,
  ci = 0.8,
  plot = FALSE,
  plot.decomp = FALSE,
  plot.fc = FALSE,
  n.hist = NULL,
  smooth = TRUE,
  dampen_cycle = FALSE,
  envelope_ci = FALSE
)
}
\arguments{
\item{model}{Structural time series model estimated using stsm_estimate.}

\item{y}{Univariate time series of data values. May also be a 2 column data frame containing a date column.}

\item{n.ahead}{Number of periods to forecast}

\item{freq}{Frequency of the data (1 (yearly), 4 (quarterly), 12 (monthly), 365.25/7 (weekly), 365.25 (daily)), default is NULL and will be automatically detected}

\item{exo}{Matrix of exogenous variables used for the historical data. Can be used to specify regression effects or other seasonal effects like holidays, etc.}

\item{exo.fc}{Matrix of exogenous variables used for the forecast}

\item{ci}{Confidence interval, value between 0 and 1 exclusive.}

\item{plot, }{Logical, whether to plot everything}

\item{plot.decomp}{Logical, whether to plot the filtered historical data}

\item{plot.fc}{Logical, whether to plot the forecast}

\item{n.hist}{Number of historical periods to include in the forecast plot. If plot = TRUE and n.hist = NULL, defaults to 3 years.}

\item{smooth}{Whether or not to use the Kalman smoother}

\item{dampen_cycle}{Whether to remove oscillating cycle dynamics and smooth the cycle forecast into the trend using a sigmoid function that maintains the rate of convergence}

\item{envelope_ci}{Whether to create a envelope for the confidence interval to smooth out seasonal fluctuations}
}
\value{
data table (or list of data tables) containing the filtered and/or smoothed series.
}
\description{
Kalman filter and forecast an estimated model from stsm_estimate output
}
\examples{
\dontrun{
#GDP Not seasonally adjusted
library(autostsm)
data("NA000334Q", package = "autostsm") #From FRED
NA000334Q = data.table(NA000334Q, keep.rownames = TRUE)
colnames(NA000334Q) = c("date", "y")
NA000334Q[, "date" := as.Date(date)]
NA000334Q[, "y" := as.numeric(y)]
NA000334Q = NA000334Q[date >= "1990-01-01", ]
stsm = stsm_estimate(NA000334Q)
fc = stsm_forecast(stsm, y = NA000334Q, n.ahead = floor(stsm$freq)*3, plot = TRUE)
}
}
