% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPLEinternal.R
\name{MPLEinternal}
\alias{MPLEinternal}
\title{Multinomial regression}
\usage{
MPLEinternal(X, z, A = NULL, groups = 2:dim(X)[2], nLambda = 101,
  centered = TRUE, BIC = TRUE, select = TRUE, standardize = TRUE,
  constraint, polish, innerIndices)
}
\arguments{
\item{X}{nxp design matrix, where the first column must contain an intercept}

\item{z}{nxk response indicator matrix, or a length n vector with the response type of each observation}

\item{A}{an adjacency matrix or list of adjacency matrices defining neighborhood structures}

\item{groups}{the grouping of the (non-intercept) coefficients. A vector of length (p-1)}

\item{nLambda}{the length of the lasso path, defaults to 101}

\item{centered}{logical, TRUE for centered and FALSE for uncentered, default is TRUE}

\item{BIC}{logical, default TRUE uses BIC and FALSE uses AIC}

\item{select}{logical, TRUE for variable selection step, default is TRUE}

\item{standardize}{logical, standarize non-intercept columns? Default is TRUE, FALSE is almost certainly a bad idea}

\item{constraint}{"symmetric" or "diagonal"}

\item{polish}{use full Newton-Raphson to sharpen convergence from BFGS}

\item{innerIndices}{indices of internal grid points}
}
\value{
a list containing the (group) lasso path,
}
\description{
Fits an automultinomial model (by pseudolikelihood). Fits the uncentered auto-model by default, 
#when an adjacency matrix is given. Performs an optional variable selection step, treating each
#variable as a group for all response categories, with an option to group related variables.
}
\examples{
#
}
\keyword{autoregression,}
\keyword{centered,}
\keyword{multinomial,}
\keyword{regression,}
\keyword{selection}
\keyword{uncentered,}
\keyword{variable,}

