% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_insert}
\alias{am_insert}
\title{Insert a value into an Automerge list}
\usage{
am_insert(doc, obj, pos, value)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID (must be a list)}

\item{pos}{Numeric index (1-based, like R vectors) where to insert, or \code{"end"}
to append}

\item{value}{The value to insert}
}
\value{
The document \code{doc} (invisibly)
}
\description{
This is an alias for \code{am_put()} with insert semantics for lists.
For lists, \code{am_put()} with a numeric index replaces the element
at that index, while \code{am_insert()} shifts elements to make room.
}
\examples{
doc <- am_create()
# Create a list and get it
am_put(doc, AM_ROOT, "items", AM_OBJ_TYPE_LIST)
items <- am_get(doc, AM_ROOT, "items")

# Insert items
am_insert(doc, items, "end", "first")
am_insert(doc, items, "end", "second")
}
