% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoforest.R
\name{autoforest}
\alias{autoforest}
\title{Create a forest of autocart trees..}
\usage{
autoforest(
  response,
  data,
  locations,
  alpha,
  beta,
  control,
  numtrees,
  mtry = NULL
)
}
\arguments{
\item{response}{The response vector that goes along with the dataframe of predictors.}

\item{data}{The dataframe of predictors.}

\item{locations}{A matrix of the locations of the dataframe of predictors.}

\item{alpha}{The percentage of weighting on spatial autocorrelation in the splitting function.}

\item{beta}{The percentage of weighting on spatial compactness in the splitting function.}

\item{control}{A control object from the \code{autocartControl} function that will be used for each tree in the forest.}

\item{numtrees}{The number of autocart trees to create in the forest.}

\item{mtry}{The number of variables to subset at each node of the splitting in the trees. By default, this will be 1/3 of the features.}
}
\value{
An object of type "autoforest", which is a list of the autocart trees.
}
\description{
Create a forest of autocart trees..
}
\examples{
# Load some data for an autoforest example
snow <- na.omit(read.csv(system.file("extdata", "ut2017_snow.csv", package = "autocart")))
y <- snow$yr50[1:40]
X <- data.frame(snow$ELEVATION, snow$MCMT, snow$PPTWT, snow$HUC)[1:40, ]
locations <- as.matrix(cbind(snow$LONGITUDE, snow$LATITUDE))[1:40, ]

# Create a control object for the autoforest tree
snow_control <- autocartControl(spatialBandwidthProportion = 1.0)

# Create an autoforest model with 5 trees
snow_model <- autoforest(y, X, locations, 0.30, 0, snow_control, numtrees = 5)

}
