\name{dataset}
\alias{dataset}
\title{The Simulated Dataset}
\description{
  The artificial datasets used for simulation on various cases. The datasets consist of:
  \itemize{
    \item \code{inhomogenous_rasch_dataset}
    \item \code{inhomogenous_dataset}
    \item \code{uncorrel_rasch_multidim}
    \item \code{uncorrel_multidim}
    \item \code{correl02_multidim}
    \item \code{correl03_multidim}
    \item \code{correl04_multidim}
    \item \code{correl05_multidim}
    \item \code{correl06_multidim}
    \item \code{withinItem_multidim}
    \item \code{testlets_dataset}
  }
}
\details{
  \code{inhomogenous_rasch_dataset} is an artificial dataset of dichotomous responses which simulates three subscales with different predictability level (discrimination parameters). This dataset is generated by

  \code{inhomogenous_rasch_dataset <- generate_data(responseType = "discriminate", ncat = 2, alpha = c(0.04,0.045,0.05,0.055,0.06,0.065,0.2,0.25,0.3,0.35,0.4,0.45,2.6,2.65,2.7,2.75,2.8,2.85,2.9))}

  \code{inhomogenous_dataset} is an artificial dataset which simulates three subscales with different predictability level (discrimination parameters). This dataset is generated by

  \code{inhomogenous_dataset <- generate_data(responseType = "discriminate", alpha = c(0.04,0.045,0.05,0.055,0.06,0.065,0.2,0.25,0.3,0.35,0.4,0.45,2.6,2.65,2.7,2.75,2.8,2.85,2.9))}

  \code{uncorrel_rasch_multidim} is an artificial dataset of dichotomous responses which simulates three uncorrelated subscales from different dimensions. This dataset is generated by

  \code{uncorrel_rasch_multidim <- generate_data(responseType = "multidim.nocorrel", ncat = 2)}

  \code{uncorrel_multidim} is an artificial dataset which simulates three uncorrelated subscales from different dimensions. This dataset is generated by

  \code{uncorrel_multidim <- generate_data(responseType = "multidim.nocorrel")}

  \code{correl02_multidim} is an artificial dataset which simulates two subscales from different dimensions that having correlation of 0.2. This dataset is generated by

  \code{correl02_multidim <- generate_data(responseType = "multidim.withcorrel", corLevel = 0.2)}

  Similarly, \code{correl03_multidim}, \code{correl04_multidim}, \code{correl05_multidim}, and \code{correl06_multidim} are artificial datasets which consist of two correlated subscales with correlation of 0.3, 0.4, 0.5, and 0.6, respectively.

  \code{withinItem_multidim} is an artificial dataset which consist of three subscales (dimensions) with some of items relate to more than one subscale (dimension). This dataset is generated by

  \code{withinItem_multidim <- generate_data(responseType = "multidim.within", ndim = 3, dim.members = list(c(1:6,13),c(3,7:12),c(5,13:18)))}

  \code{testlets_dataset} is an artificial dataset which consist of two subscales with some of items relate to more than one subscale (dimension). This dataset is generated by

  \code{testlets_dataset <- generate_data(responseType = "testlets", ndim = 2, sdlambda = c(0,4))}


}
\examples{
  #res <- pcm(poly_inh_dset)
  #res
  #summary(res)

  #pcmdif_res <- pcm_dif(polydif_inh_dset, groups_map = c(rep(1,245),rep(0,245)))
  #fit_res <- fitStats(pcmdif_res)
  #summary(fit_res)
  #plot(fit_res, plotx = "gamma", ploty = "outfit")

}
\seealso{
  \code{\link{pcm}}, \code{\link{pcm_dif}}, \code{\link{gpcm}}, \code{\link{gpcm_dif}}
}
