% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_halfnormal.R
\name{score_halfnormal}
\alias{score_halfnormal}
\alias{scoreHalfNormal}
\title{Half-Normal Score}
\usage{
score_halfnormal(object, ...)

scoreHalfNormal(object, ...)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{...}{Extra arguments passed to \link[hnp]{hnp}.}
}
\value{
An object of class 'score_audit'.
}
\description{
Score is approximately:
\eqn{ \sum{\#[res_i \leq simres_{i,j}] - n } }
with the distinction that each element of sum is also scaled to take values from [0,1].

\eqn{res_i} is a residual for i-th observation, \eqn{simres_{i,j}} is the residual of j-th simulation for i-th observation, and \eqn{n} is the number of simulations for each observation.
Scores are calculated on the basis of simulated data, so they may differ between function calls.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# create an explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# calculate score
score_halfnormal(exp_lm)

}
