% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/on_error.R
\name{on_error}
\alias{on_error}
\title{Add a function to be run on error}
\usage{
on_error(f)
}
\arguments{
\item{f}{a function to call on error}
}
\value{
A local error handler.
}
\description{
This function behaves as `on.exit()`, but is run on error, and supports mappers.
}
\examples{

y <- function(num){
  on_error(~ write( Sys.time(), "error_log.txt", append = TRUE) )
  log(num)
}

}
