% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_to_description.R
\name{att_to_description}
\alias{att_to_description}
\alias{att_to_desc_from_pkg}
\alias{att_amend_desc}
\title{Amend DESCRIPTION with dependencies read from package code parsing}
\usage{
att_to_description(
  path = ".",
  path.n = "NAMESPACE",
  path.d = "DESCRIPTION",
  dir.r = "R",
  dir.v = "vignettes",
  dir.t = "tests",
  extra.suggests = NULL,
  pkg_ignore = NULL,
  document = TRUE
)

att_to_desc_from_pkg(
  path = ".",
  path.n = "NAMESPACE",
  path.d = "DESCRIPTION",
  dir.r = "R",
  dir.v = "vignettes",
  dir.t = "tests",
  extra.suggests = NULL,
  pkg_ignore = NULL,
  document = TRUE
)

att_amend_desc(
  path = ".",
  path.n = "NAMESPACE",
  path.d = "DESCRIPTION",
  dir.r = "R",
  dir.v = "vignettes",
  dir.t = "tests",
  extra.suggests = NULL,
  pkg_ignore = NULL,
  document = TRUE
)
}
\arguments{
\item{path}{path to the root of the package directory. Default to current directory.}

\item{path.n}{path to namespace file.}

\item{path.d}{path to description file.}

\item{dir.r}{path to directory with R scripts.}

\item{dir.v}{path to vignettes directory. Set to empty (dir.v = "") to ignore.}

\item{dir.t}{path to tests directory. Set to empty (dir.t = "") to ignore.}

\item{extra.suggests}{vector of other packages that should be added in Suggests (pkgdown, covr for instance)}

\item{pkg_ignore}{vector of packages names to ignore.}

\item{document}{Run function roxygenise of roxygen2 package}
}
\value{
Update DESCRIPTION file.
att_to_desc_from_pkg(), att_amend_desc() are aliases
}
\description{
Amend DESCRIPTION with dependencies read from package code parsing
}
\examples{
tmpdir <- tempdir()
file.copy(system.file("dummypackage",package = "attachment"), tmpdir,
 recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")
# browseURL(dummypackage)
att_amend_desc(path = dummypackage)
}
