% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-line.R
\name{plot_line}
\alias{plot_line}
\title{Function to plot time series of atlantis ncdf output.}
\usage{
plot_line(data, x = "time", y = "atoutput", wrap = "species",
  col = NULL, ncol = 7, yexpand = FALSE)
}
\arguments{
\item{data}{Dataframe to be plotted.}

\item{x}{x-variable. Default is \code{'time'}.}

\item{y}{y-variable. Default is \code{'atoutput'}.}

\item{wrap}{Wraping column. Default is \code{'species'}}

\item{col}{Column to use as colour. Default is \code{NULL}.}

\item{ncol}{Number of columns in multipanel plot. Default is \code{7}.}

\item{yexpand}{Expands the y axis so it always includes 0. Default is \code{FALSE}.}
}
\value{
ggplot2 object
}
\description{
Function to plot time series of atlantis ncdf output.
}
\examples{
plot_line(preprocess$biomass)
plot_line(preprocess$biomass, col = "species")
plot_line(preprocess$biomass_age, col = "agecl")
plot_line(preprocess$biomass_age, wrap = "agecl", col = "species")

# The function can also be used to compare model outoput with observed data.
d <- system.file("extdata", "setas-model-new-becdev", package = "atlantistools")
ex_data <- read.csv(file.path(d, "setas-bench.csv"), stringsAsFactors = FALSE)
names(ex_data)[names(ex_data) == "biomass"] <- "atoutput"

data <- preprocess$biomass
data$model <- "atlantis"
comp <- rbind(ex_data, data, stringsAsFactors = FALSE)

# Show atlantis as first factor!
lev_ord <- c("atlantis", sort(unique(comp$model))[sort(unique(comp$model)) != "atlantis"])
comp$model <- factor(comp$model, levels = lev_ord)

# Create plot
plot_line(comp, col = "model")

\dontrun{
# Use \\code{\\link{convert_relative_initial}} and \\code{\\link{plot_add_box}}
# with \\code{\\link{plot_line}}. Use \\code{\\link{convert_relative_initial}} to
# generate a relative time series first.
df <- convert_relative_initial(preprocess$structn_age)

# Create the base plot with \\code{\\link{plot_line}}.
plot <- plot_line(df, col = "agecl")

# Add lower and upper range.
plot_add_box(plot)

# Create spatial timeseries plots in conjuction with \\code{\\link{custom_grid}}.
plot <- plot_line(preprocess$physics, wrap = NULL)
custom_grid(plot, grid_x = "polygon", grid_y = "variable")

plot <- plot_line(preprocess$flux, wrap = NULL, col = "variable")
custom_grid(plot, grid_x = "polygon", grid_y = "layer")
}
}
\seealso{
Other plot functions: \code{\link{plot_bar}},
  \code{\link{plot_boxes}},
  \code{\link{plot_diet_bec_dev}}, \code{\link{plot_diet}},
  \code{\link{plot_rec}}, \code{\link{plot_species}}
}
