% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_asympto.R
\name{estimate_asympto}
\alias{estimate_asympto}
\title{Estimate the proportion of asymptomatic cases by capture/recapture}
\usage{
estimate_asympto(date, cases, deaths, bounds = c("lower", "upper"))
}
\arguments{
\item{date}{A vector containing the dates}

\item{cases}{A numeric vector containing the number of new cases at each
\code{date} (\strong{not} the cumulative number of cases).}

\item{deaths}{A numeric vector containing the number of new deaths at each
\code{date} (\strong{not} the cumulative number of cases).}

\item{bounds}{\code{"lower"}, \code{"upper"}, or both \verb{c("lower, "upper"}) (the
default), telling which bounds of the number of asymptomatic cases are
computed.
associated with the lower and upper bounds.
estimation. \code{FALSE} is never the recommended setting excepted for testing
or debugging purpose.}
}
\value{
A \code{data.frame} with two or three columns (depending on the value of
the \code{bounds} argument):
\itemize{
\item \code{date}: the original \code{date} column
\item \code{lower}: the lower bound of asymptomatic cases
\item \code{upper}: the upper bound of asymptomatic cases
}
}
\description{
Estimate the proportion of asymptomatic cases by capture/recapture
}
\examples{

d <- readRDS(system.file("extdata", "covid19_italy.rds", package = "asymptor"))
head(d)

estimate_asympto(d$date, d$new_cases, d$new_deaths)

}
\references{
Böhning D., Rocchetti I., Maruotti A., Holling H. (2020),
Estimating the undetected infections in the Covid-19 outbreak by harnessing
capture–recapture methods, International Journal of Infectious Diseases,
97, p197-201, \doi{10.1016/j.ijid.2020.06.009}.

Rocchetti I., Böhning D., Holling H., Maruotti A., (2020),
Estimating the size of undetected cases of the SARS-CoV-2 outbreak in
Europe: An upperbound estimator, medRxiv,
\doi{10.1101/2020.07.14.20153445}.
}
