% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{translate}
\alias{translate}
\title{Translates a R function into a C++ function and returns an external pointer (XPtr) to this function.
Further information can be found in the vignette: 'Detailed Documentation'.}
\usage{
translate(f, verbose = FALSE, reference = FALSE)
}
\arguments{
\item{f}{The function which should be translated from R to C++.}

\item{verbose}{If set to TRUE the output of RcppXPtrUtils::cppXPtr is printed.}

\item{reference}{If set to true the arguments are passed by reference.}
}
\value{
The external pointer of the generated C++ function
}
\description{
Translates a R function into a C++ function and returns an external pointer (XPtr) to this function.
Further information can be found in the vignette: 'Detailed Documentation'.
}
\details{
\strong{The following types are supported: }
 \enumerate{
   \item numeric vectors
   \item numeric matrices
 }
 Variables can be either numeric vectors or matrices.
 Notably, it is possible that the variables change the type within the function.
 \strong{It is possible to declare a variable of a scalar numeric data type.
         This is done by adding '_db' to the end of the variable. Each time '_db' is found
         the variable is declared as a scalar numeric data type. In this case the
         object cannot change its type!}

\strong{The following functions are supported:}
 \enumerate{
   \item assignment: = and <-
   \item allocation: vector and matrix
   \item information about objects: length and dim
   \item Basic operations: +, -, *, /
   \item Indices: [] and at
   \item mathematical functions: sin, asin, sinh, cos, acos, cosh, tan, atan, tanh, log, ^ and exp
   \item concatenate objects: c
   \item comparison: ==, !=, >, <, >= and <=
   \item printing: print
   \item returning objects: return
   \item catmull-rome spline: cmr
   \item to get a range of numbers the ':' function can be used
 }

\strong{Some details about the implemented functions}

\itemize{
   \item allocation of memory works: Following forms are possible: vector(size_of_elements), vector(value, size_of_elements), vector(other_vec, size_of_other_vec),
             matrix(nrows, ncols), matrix(value, nrows, ncols) and matrix(vector, nrows, ncols). The latter fills the matrix or the vector with the specified 'value'.
   \item For indices squared brackets '[]' can be used as common in R. \strong{Despite the results of calculations cannot be used!} Beyond that the function 'at' exists
             which accepts as first argument a variable and as the second argument you pass the desired index.
             The caveat of using 'at' is that only one entry can be accessed. The function '[]' can return more then one element.
             \strong{The 'at'function returns a reference to the vector entry.
               Therefore variable[index] can behave differently then at(variable, index).
               The function has to be used carefully when 'at' is used.
               Especially if '[]' and 'at' are mixed the function behaviour is difficult to predict.
               Please test it before using it in a serious project.}
   \item For-loops can be written as common in R
           \itemize{
               \item Nr.1 \cr
                     for(index in variable)\{ \cr
                       # do whatever \cr
                     \} \cr
               \item Nr.2 \cr
                     for(index in 1:length(variable)\{ \cr
                       # do whatever \cr
                     \} \cr
   }
   \item Be aware that it is not possible to assign the result of a comparison to a variable.
   \item The print function accepts either a scalar, vector, matrix, string, bool or nothing (empty line).
   \item In order to return an object use the 'return' function (The last object is not returned automatically as in R).
   \item In order to interpolate values the 'cmr' function can be used. The function needs three arguments.
         \enumerate{
           \item the first argument is the point of the independent variable (x) for which the dependent variable should be calculated (y). This has to be a vector of length one.
           \item the second argument is a vector defining the points of the independent variable (x). This has to be a vector of at least length four.
           \item the third argument is a vector defining the points of the dependent variable (y). This has to be a vector of at least length four.
       }
 }
\strong{Be aware that the R code is translated to ETR an expression template library which tries to mimic R.
However, it does not behave exactly like R! Please check your compiled function before using it in a serious project.
If you want to see how ast2ast differs from R in detail check the vignette: 'Detailed Documentation'.}
}
\examples{
#Further examples can be found in the vignette: 'Detailed Documentation'.
#Hello World
\dontrun{
f <- function() { print("Hello World!")}
pointer_to_f_cpp <- ast2ast::translate(f)
Rcpp::sourceCpp(code = "
#include <Rcpp.h>
typedef void (*fp)();

// [[Rcpp::export]]
void call_fct(Rcpp::XPtr<fp> inp) {
  fp f = *inp;
  f();
}
")
call_fct(pointer_to_f_cpp)
}
}
