% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{has_all_names}
\alias{has_all_names}
\title{Returns TRUE if data.frame or list has specified names}
\usage{
has_all_names(...)
}
\arguments{
\item{...}{A arbitrary amount of quoted names to check for}
}
\value{
TRUE is all names exist, FALSE if not
}
\description{
This function checks parent frame environment for existence of names.
This is meant to be used with `assertr`'s `verify` function to check
for the existence of specific column names in a `data.frame` that is
piped to `verify`. It can also work on a non-`data.frame` list.
}
\examples{

verify(mtcars, has_all_names("mpg", "wt", "qsec"))

library(magrittr)   # for pipe operator

\dontrun{
mtcars \%>\%
  verify(has_all_names("mpgg"))  # fails
}

mpgg <- "something"

mtcars \%>\%
  verify(exists("mpgg"))   # passes but big mistake

\dontrun{
mtcars \%>\%
  verify(has_all_names("mpgg")) # correctly fails
}

}
\seealso{
\code{\link{exists}}
}
