% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/are-same.R, R/assert-are-same.R
\name{are_identical}
\alias{are_identical}
\alias{assert_all_are_identical}
\alias{assert_any_are_identical}
\title{Are the inputs identical}
\usage{
are_identical(...)

assert_all_are_identical(...)

assert_any_are_identical(...)
}
\arguments{
\item{...}{Some R expressions}
}
\value{
A symmetric square logical matrix which is \code{TRUE} where pairs
of inputs are identical.
}
\description{
Generalisation of \code{identical} to an arbitrary number of inputs.
}
\examples{
x <- 1:5
are_identical(cos(pi), -1, x, (2:6) - 1L)
assert_any_are_identical(cos(pi), -1, x, (2:6) - 1L)
dont_stop(assert_all_are_identical(cos(pi), -1, x, (2:6) - 1L))
}
\seealso{
\code{\link[base]{identical}}, \code{\link{are_same_length}}
}

