% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-condition.R, R/is-condition.R
\name{assert_is_try_error}
\alias{assert_is_condition}
\alias{assert_is_error}
\alias{assert_is_message}
\alias{assert_is_simple_error}
\alias{assert_is_simple_message}
\alias{assert_is_simple_warning}
\alias{assert_is_try_error}
\alias{assert_is_warning}
\alias{is_condition}
\alias{is_error}
\alias{is_message}
\alias{is_simple_error}
\alias{is_simple_message}
\alias{is_simple_warning}
\alias{is_try_error}
\alias{is_warning}
\title{Is the input a condition?}
\usage{
assert_is_try_error(x, severity = getOption("assertive.severity", "stop"))

assert_is_simple_error(x, severity = getOption("assertive.severity", "stop"))

assert_is_error(x, severity = getOption("assertive.severity", "stop"))

assert_is_simple_warning(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_warning(x, severity = getOption("assertive.severity", "stop"))

assert_is_simple_message(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_message(x, severity = getOption("assertive.severity", "stop"))

assert_is_condition(x, severity = getOption("assertive.severity", "stop"))

is_try_error(x, .xname = get_name_in_parent(x))

is_simple_error(x, .xname = get_name_in_parent(x))

is_error(x, .xname = get_name_in_parent(x))

is_simple_warning(x, .xname = get_name_in_parent(x))

is_warning(x, .xname = get_name_in_parent(x))

is_simple_message(x, .xname = get_name_in_parent(x))

is_message(x, .xname = get_name_in_parent(x))

is_condition(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
The \code{is_*} functions return \code{TRUE} or \code{FALSE}
depending upon whether or not the input is a datetime object.

The \code{assert_*} functions return nothing but throw an error if the
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the input is a message, warning or error.
}
\examples{
# stop returns simpleErrors, unless wrapped in a call to try
simple_err <- tryCatch(stop("!!!"), error = function(e) e)
is_simple_error(simple_err)
try_err <- try(stop("!!!"))
is_try_error(try_err)

# is_error checks for both error types
is_error(try_err)
is_error(simple_err)

# warning returns simpleWarnings
simple_warn <- tryCatch(warning("!!!"), warning = function(w) w)
is_simple_warning(simple_warn)
is_warning(simple_warn)

# message returns simpleMessages
simple_msg <- tryCatch(message("!!!"), message = function(m) m)
is_simple_message(simple_msg)
is_message(simple_msg)

# These examples should fail.
assertive.base::dont_stop(assert_is_simple_error(try_err))
assertive.base::dont_stop(assert_is_try_error(simple_err))
}

