% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-special-string.R, R/is-special-string.R
\name{assert_all_are_single_characters}
\alias{assert_all_are_single_characters}
\alias{assert_any_are_single_characters}
\alias{is_single_character}
\title{Is the input a single character?}
\usage{
assert_all_are_single_characters(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_single_characters(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_single_character(x, .xname)
}
\arguments{
\item{x}{A character vector.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_single_character} returns \code{TRUE} when the input is a 
single character (as determined by \code{nchar}; this excludes \code{NA}).
The \code{assert_*} functions return nothing but throw an error if the 
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if he unput is a single character.
}
\note{
The behaviour of this function has changed so that \code{NA} inputs 
now return \code{NA} rather than \code{FALSE}.
}
\examples{
x <- c("", "a", "aa", NA)
is_single_character(x)
}
\seealso{
\code{\link[base]{nchar}}
}

