% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-monotonic.R, R/is-monotonic.R
\name{assert_is_monotonic_increasing}
\alias{assert_is_monotonic_decreasing}
\alias{assert_is_monotonic_increasing}
\alias{is_monotonic}
\alias{is_monotonic_decreasing}
\alias{is_monotonic_increasing}
\title{Is the vector monotonically increasing or decreasing?}
\usage{
assert_is_monotonic_increasing(x, strictly = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_is_monotonic_decreasing(x, strictly = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_monotonic_increasing(x, strictly = FALSE, .xname = get_name_in_parent(x))

is_monotonic_decreasing(x, strictly = FALSE, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{strictly}{Logical. If \code{TRUE}, the input is checked for being 
strictly monotonic; that is, consecutive values cannot be equal.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\description{
Checks to see if the input is monotonically increasing or decreasing.
}
\examples{
x <- c(1, 2, 2, 1, 3, 2)
is_monotonic_increasing(x)
is_monotonic_increasing(x, TRUE)
is_monotonic_decreasing(x)
is_monotonic_decreasing(x, TRUE)

# Also works with, e.g., dates & times
is_monotonic_increasing(Sys.time() + x)

# These checks should fail
assertive.base::dont_stop({
  assert_is_monotonic_increasing(x)
  assert_is_monotonic_decreasing(x)
})
}

