% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-date-string.R, R/is-date-string.R
\name{assert_all_are_date_strings}
\alias{assert_all_are_date_strings}
\alias{assert_any_are_date_strings}
\alias{is_date_string}
\title{Does the character vector contain dates?}
\usage{
assert_all_are_date_strings(x, format = "\%F \%T", na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_date_strings(x, format = "\%F \%T", na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_date_string(x, format = "\%F \%T", .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{format}{Expected format of the dates.  See 
\code{\link[base]{strptime}}.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
A logical vector that is \code{TRUE} when the input contains valid 
dates or times.
}
\description{
Checks that the input contains dates or times.
}
\examples{
x <- c("9999-12-31 23:59:59", "wednesday", NA)
is_date_string(x)
assert_all_are_date_strings("01Aug1979", format = "\%d\%b\%Y") #My DOB!
}
\seealso{
\code{\link[base]{strptime}} for specifying formats, and the 
\code{lubridate} package for automatic guessing of date formats (and other 
date manipulation functions).
}

