% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_matrix}
\alias{assert_matrix}
\title{Assert input is a matrix}
\usage{
assert_matrix(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not a matrix}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a matrix, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert input is a matrix
}
\examples{
try({
assert_matrix(matrix(1:9, 3)) # Passes
assert_matrix(matrix(1:9, 3, 3)) # Passes
assert_matrix(c(1, 2, 3)) # Throws default error
assert_matrix(1:10, "Custom error message") # Throws custom error
})

}
\concept{assert_type}
