% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_list}
\alias{assert_list}
\title{Assert input is a list}
\usage{
assert_list(
  x,
  include_dataframes = FALSE,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object}

\item{include_dataframes}{A logical indicating whether data_frames should be considered vectors. Default is \code{FALSE}.}

\item{msg}{A character string containing the error message to display if \code{x} is not a list}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a list, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert input is a list
}
\examples{
try({
# Assert that a variable is a list
x <- list(1, 2, 3)
assert_list(x)  # does nothing

# Assert that a variable is not a list
x <- "not a list"
assert_list(x)  # stops execution and prints an error message
})

}
\concept{assert_type}
