% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_files.R
\name{assert_file_exists}
\alias{assert_file_exists}
\title{Assert a file exists}
\usage{
assert_file_exists(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{Path to a file (string)}

\item{msg}{A character string containing the error message if file \code{x} is does not exist}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if file \code{x} exists, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that a file exists.
To assert all files in a vector exist, see \code{\link[=assert_all_files_exist]{assert_all_files_exist()}}
}
\examples{
real_file <- system.file("DESCRIPTION", package = "assertions")

try({
assert_file_exists(real_file) # PASSES
assert_file_exists("foo") # Throws Error
assert_file_exists(c(real_file, real_file)) # Throws Error (should use assert_all_files_exist)

})

}
\concept{assert_file}
