% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svg.R
\name{play}
\alias{play}
\title{Play asciinema cast as an SVG image in the default browser}
\usage{
play(cast, ...)
}
\arguments{
\item{cast}{\code{asciicast} object}

\item{...}{Additional arguments are passed to \code{\link[=write_svg]{write_svg()}}.}
}
\value{
The path of the temporary SVG file, invisibly.
}
\description{
Uses \code{\link[=write_svg]{write_svg()}} to create an SVG image for a cast, in a temporary
file, and then previews a minimal HTML file with the SVG image,
in the default browser.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cast <- read_cast(system.file("examples", "hello.cast", package = "asciicast"))
play(cast)
\dontshow{\}) # examplesIf}
}
\seealso{
Other SVG functions: 
\code{\link{default_theme}()},
\code{\link{write_svg}()}
}
\concept{SVG functions}
