% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissimilarity.R
\docType{class}
\name{proximity-classes}
\alias{proximity-classes}
\alias{ar_similarity-class}
\alias{ar_cross_dissimilarity-class}
\title{Classes dist, ar_cross_dissimilarity and ar_similarity --- Proximity
Matrices}
\description{
Simple classes to represent proximity matrices.
}
\details{
For compatibility with
clustering functions in \code{R}, we represent dissimilarities as the
\code{S3} class \code{dist}.  For cross-dissimilarities and similarities, we
provide the \code{S4} classes \code{ar_cross_dissimilarities} and
\code{ar_similarities}.
}
\section{Objects from the Class}{
 \code{dist} objects are the result of
calling the method \code{dissimilarity()} with one argument or any
\code{R} function returning a \verb{S3 dist} object.

\code{ar_cross_dissimilarity} objects are the result of calling the method
\code{dissimilarity()} with two arguments, by calls of the form
\code{new("similarity", ...)}, or by coercion from matrix.

\code{ar_similarity} objects are the result of calling the method
\code{\link[=affinity]{affinity()}}, by calls of the form \code{new("similarity", ...)},
or by coercion from matrix.
}

\seealso{
\code{\link[stats:dist]{stats::dist()}}, \code{\link[proxy:dist]{proxy::dist()}}

Other proximity classes and functions: 
\code{\link{affinity}()},
\code{\link{dissimilarity}()},
\code{\link{predict}()}
}
\author{
Michael Hahsler
}
\concept{proximity classes and functions}
\keyword{classes}
