% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\docType{class}
\name{transactions-class}
\alias{transactions-class}
\alias{transactions}
\alias{initialize,transactions-method}
\alias{show,transactions-method}
\alias{summary,transactions-method}
\alias{summary.transactions-class}
\alias{show,summary.transactions-method}
\alias{toLongFormat,transactions-method}
\alias{t-transactions}
\alias{t,transactions-method}
\alias{items,transactions-method}
\alias{transactionInfo}
\alias{transactionInfo,transactions-method}
\alias{transactionInfo<-}
\alias{transactionInfo<-,transactions-method}
\alias{dimnames,transactions-method}
\alias{dimnames<-,transactions,list-method}
\alias{coercion-transactions}
\alias{coerce,transactions,matrix-method}
\alias{coerce,matrix,transactions-method}
\alias{coerce,list,transactions-method}
\alias{coerce,transactions,list-method}
\alias{coerce,data.frame,transactions-method}
\alias{coerce,transactions,data.frame-method}
\alias{coerce,ngCMatrix,transactions-method}
\title{Class transactions --- Binary Incidence Matrix for Transactions}
\usage{
transactions(
  x,
  itemLabels = NULL,
  transactionInfo = NULL,
  format = "wide",
  cols = NULL
)

\S4method{summary}{transactions}(object)

\S4method{toLongFormat}{transactions}(from, cols = c("TID", "item"), decode = TRUE)

\S4method{items}{transactions}(x)

transactionInfo(x)

\S4method{transactionInfo}{transactions}(x)

transactionInfo(x) <- value

\S4method{transactionInfo}{transactions}(x) <- value

\S4method{dimnames}{transactions}(x)

\S4method{dimnames}{transactions,list}(x) <- value
}
\arguments{
\item{x, object, from}{the object}

\item{itemLabels}{a vector with labels for the items}

\item{transactionInfo}{a transaction information data.frame with one row per transaction.}

\item{format}{\code{"wide"} or \code{"long"} format?
Format wide is a regular data.frame where each row contains an object.
Format "long" is a data.frame with one column with transaction IDs and one with an
item (see \code{cols} below).}

\item{cols}{a numeric or character vector of length two giving the index or names of
the columns (fields) with the transaction and item ids in the long format.}

\item{decode}{translate item IDs to item labels?}

\item{value}{replacement value}
}
\description{
The \code{transactions} class is a subclass of \link{itemMatrix} and
represents transaction data used for mining \link{associations}.
}
\details{
Transactions are a direct extension of class \link{itemMatrix}
to store a binary incidence matrix, item labels, and optionally transaction
IDs and user IDs.
Transactions are represented as sparse binary matrices of class
\link{itemMatrix}. If you work with several transaction sets at the
same time, then the encoding (order of the items in the binary matrix) in
the different sets is important. See \link{itemCoding} to learn how
to encode and recode transaction sets.

Note that you will need to prepare your data first (see coercion methods in
the Methods Section and the Example Section below for details on the needed
format).
\itemize{
\item \strong{Continuous variables:} Association rule mining can only use items and
does not work with continuous variables. Continuous variables need to be
discretized first. An item resulting from discretization might be
\code{age>18} and the column contains only \code{TRUE} or \code{FALSE}.
Alternatively it can be a factor with levels \code{age<=18},
\verb{50=>age>18} and \code{age>50}. These will be automatically converted
into 3 items, one for each level. Have a look at the function
\code{\link[=discretize]{discretize()}} for automatic discretization.
\item \strong{Logical variables:} A logical variable describing a person could be
\code{tall} indicating if the person is tall using the values \code{TRUE}
and \code{FALSE}. The fact that the person is tall would be encoded in the
transaction containing the item \code{tall} while not tall persons would not
have this item. Therefore, for logical variables, the \code{TRUE} value is
converted into an item with the name of the variable and for the
\code{FALSE} values no item is created.
\item \strong{Factors:} The function also can convert columns with nominal values
(i.e., factors) into a series of binary items (one for each level
constructed as \verb{variable name = level}). Note that nominal variables
need to be encoded as factors (and not characters or numbers). This can be
done with

\code{data[,"a_nominal_var"] <- factor(data[,"a_nominal_var"])}.

Complete examples for how to prepare data can be found in the man pages for
\link{Income} and \link{Adult}.
}
}
\section{Functions}{
\itemize{
\item \code{summary,transactions-method}: produce a summary

\item \code{toLongFormat,transactions-method}: convert the transactions to long format
(a data.frame with two columns, tid and item). Column names can
be specified as a character vector of length 2 called \code{cols}.

\item \code{items,transactions-method}: get the transactions as an \link{itemMatrix}

\item \code{transactionInfo,transactions-method}: get the transaction info data.frame

\item \code{transactionInfo<-,transactions-method}: replace the transaction info data.frame

\item \code{dimnames,transactions-method}: get the dimnames

\item \code{dimnames<-,transactions,list-method}: set the dimnames
}}

\section{Slots}{

Slots are inherited from \link{itemMatrix}.
}

\section{Objects from the Class}{

Objects are created by:
\itemize{
\item coercion from objects of other classes. \code{itemLabels} and \code{transactionInfo} are
by default created from information in \code{x} (e.g., from row and column names).
\item the constructor function \code{transactions()}
\item by calling \code{new("transactions", ...)}.
}

See Examples Section for creating transactions from data.
}

\section{Coercion}{

\itemize{
\item as("transactions", "matrix")
\item as("matrix", "transactions")
\item as("list", "transactions")
\item as("transactions", "list")
\item as("data.frame", "transactions")
\item as("transactions", "data.frame")
\item as("ngCMatrix", "transactions")
}
}

\examples{
## Example 1: creating transactions form a list (each element is a transaction)
a_list <- list(
      c("a","b","c"),
      c("a","b"),
      c("a","b","d"),
      c("c","e"),
      c("a","b","d","e")
      )

## Set transaction names
names(a_list) <- paste("Tr", c(1:5), sep = "")
a_list

## Use the constructor to create transactions
## Note: S4 coercion does the same trans1 <- as(a_list, "transactions")
trans1 <- transactions(a_list)
trans1

## Analyze the transactions
summary(trans1)
image(trans1)

## Example 2: creating transactions from a 0-1 matrix with 5 transactions (rows) and
##            5 items (columns)
a_matrix <- matrix(
  c(1, 1, 1, 0, 0,
	   1, 1, 0, 0, 0,
	   1, 1, 0, 1, 0,
	   0, 0, 1, 0, 1,
	   1, 1, 0, 1, 1), ncol = 5)

## Set item names (columns) and transaction labels (rows)
colnames(a_matrix) <- c("a", "b", "c", "d", "e")
rownames(a_matrix) <- paste("Tr", c(1:5), sep = "")

a_matrix

## Create transactions
trans2 <- transactions(a_matrix)
trans2
inspect(trans2)

## Example 3: creating transactions from data.frame (wide format)
a_df <- data.frame(
	age   = as.factor(c( 6,   8,   NA, 9,   16)),
	grade = as.factor(c("A", "C", "F", NA, "C")),
  pass  = c(TRUE, TRUE, FALSE, TRUE, TRUE))
## Note: factors are translated differently than logicals and NAs are ignored
a_df

## Create transactions
trans3 <- transactions(a_df)
inspect(trans3)

## Note that coercing the transactions back to a data.frame does not recreate the
## original data.frame, but represents the transactions as sets of items
as(trans3, "data.frame")

## Example 4: creating transactions from a data.frame with
## transaction IDs and items (long format)
a_df3 <- data.frame(
  TID =  c( 1,   1,   2,   2,   2,   3 ),
  item = c("a", "b", "a", "b", "c", "b")
)
a_df3
trans4 <- transactions(a_df3, format = "long", cols = c("TID", "item"))
trans4
inspect(trans4)

## convert transactions back into long format.
toLongFormat(trans4)

## Example 5: create transactions from a dataset with numeric variables
## using discretization.
data(iris)

irisDisc <- discretizeDF(iris)
head(irisDisc)

trans5 <- transactions(irisDisc)
trans5
inspect(head(trans5))

## Note, creating transactions without discretizing numeric variables will apply the
## default discretization and also create a warning.


## Example 6: create transactions manually (with the same item coding as in trans5)
trans6 <- transactions(
  list(
    c("Sepal.Length=[4.3,5.4)", "Species=setosa"),
    c("Sepal.Length=[4.3,5.4)", "Species=setosa")
  ), itemLabels = trans5)
trans6

inspect(trans6)
}
\seealso{
Superclass: \link{itemMatrix}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{itemMatrix and transactions functions}
\keyword{classes}
