% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.tableby.R
\name{summary.tableby}
\alias{summary.tableby}
\alias{as.data.frame.summary.tableby}
\title{The summary method for a \code{tableby} object}
\usage{
\method{summary}{tableby}(object, ..., labelTranslations = NULL,
  text = FALSE, title = NULL, pfootnote = FALSE, term.name = "")

\method{as.data.frame}{summary.tableby}(x, ..., text = x$text,
  pfootnote = x$pfootnote, term.name = x$term.name, width = NULL,
  min.split = NULL, list.ok = FALSE)
}
\arguments{
\item{object}{An object of class \code{"tableby"}, made by the \code{\link{tableby}} function.}

\item{...}{For \code{summary.tableby}, other arguments passed to \code{\link{as.data.frame.tableby}}.
For \code{print}ing the summary object, these are passed to both \code{as.data.frame.summary.tableby} and
\code{\link[knitr]{kable}}.}

\item{labelTranslations}{A named list (or vector) where the name is the label in the
output to be replaced in the pretty rendering by the character string
value for the named element of the list, e.g., \code{list(age = "Age(Years)", meansd = "Mean(SD)")}.}

\item{text}{An argument denoting how to print the summary to the screen.
Default is \code{FALSE} (show markdown output). \code{TRUE} and \code{NULL} output a text-only version, with
the latter avoiding all formatting.
\code{"html"} uses the HTML tag \code{<strong>} instead of the markdown formatting, and \code{"latex"} uses
the LaTeX command \code{\\textbf}.}

\item{title}{Title for the table, defaulting to \code{NULL} (no title)}

\item{pfootnote}{Logical, denoting whether to put footnotes describing the tests used to generate the p-values.}

\item{term.name}{A character vector denoting the column name for the "terms" column. It should be the same length
as the number of tables or less (it will get recycled if needed). The special value \code{TRUE} will
use the y-variable's label for each table.}

\item{x}{An object of class \code{"summary.tableby"}.}

\item{width}{Passed to \code{\link{smart.split}} for formatting of the "term" column.}

\item{min.split}{Passed to \code{\link{smart.split}} for formatting of the "term" column.}

\item{list.ok}{If the object has multiple by-variables, is it okay to return a list of data.frames instead of a single data.frame?
If \code{FALSE} but there are multiple by-variables, a warning is issued.}
}
\value{
An object of class \code{summary.tableby}
}
\description{
The summary method for a \code{\link{tableby}} object, which is a pretty rendering of a \code{\link{tableby}}
object into a publication-quality results table in R Markdown, and can render well in text-only.
}
\examples{

set.seed(100)
## make 3+ categories for response
nsubj <- 90
mdat <- data.frame(Response=sample(c(1,2,3),nsubj, replace=TRUE),
                   Sex=sample(c("Male", "Female"), nsubj,replace=TRUE),
                   Age=round(rnorm(nsubj,mean=40, sd=5)),
                   HtIn=round(rnorm(nsubj,mean=65,sd=5)))

## allow default summaries on RHS variables
out <- tableby(Response ~ Sex + Age + HtIn, data=mdat)
summary(out, text=TRUE)
labels(out)
labels(out) <- c(Age="Age (years)", HtIn="Height (inches)")
summary(out, stats.labels=c(meansd="Mean-SD", q1q3 = "Q1-Q3"), text=TRUE)

}
\seealso{
\code{\link{tableby.control}}, \code{\link{tableby}}
}
\author{
Ethan Heinzen, based on code by Gregory Dougherty, Jason Sinnwell, Beth Atkinson,
  adapted from SAS Macros written by Paul Novotny and Ryan Lennon
}
