% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feather.R
\name{write_feather}
\alias{write_feather}
\alias{write_ipc_file}
\title{Write a Feather file (an Arrow IPC file)}
\usage{
write_feather(
  x,
  sink,
  version = 2,
  chunk_size = 65536L,
  compression = c("default", "lz4", "lz4_frame", "uncompressed", "zstd"),
  compression_level = NULL
)

write_ipc_file(
  x,
  sink,
  chunk_size = 65536L,
  compression = c("default", "lz4", "lz4_frame", "uncompressed", "zstd"),
  compression_level = NULL
)
}
\arguments{
\item{x}{\code{data.frame}, \link{RecordBatch}, or \link{Table}}

\item{sink}{A string file path, connection, URI, or \link{OutputStream}, or path in a file
system (\code{SubTreeFileSystem})}

\item{version}{integer Feather file version, Version 1 or Version 2. Version 2 is the default.}

\item{chunk_size}{For V2 files, the number of rows that each chunk of data
should have in the file. Use a smaller \code{chunk_size} when you need faster
random row access. Default is 64K. This option is not supported for V1.}

\item{compression}{Name of compression codec to use, if any. Default is
"lz4" if LZ4 is available in your build of the Arrow C++ library, otherwise
"uncompressed". "zstd" is the other available codec and generally has better
compression ratios in exchange for slower read and write performance.
"lz4" is shorthand for the "lz4_frame" codec.
See \code{\link[=codec_is_available]{codec_is_available()}} for details.
\code{TRUE} and \code{FALSE} can also be used in place of "default" and "uncompressed".
This option is not supported for V1.}

\item{compression_level}{If \code{compression} is "zstd", you may
specify an integer compression level. If omitted, the compression codec's
default compression level is used.}
}
\value{
The input \code{x}, invisibly. Note that if \code{sink} is an \link{OutputStream},
the stream will be left open.
}
\description{
Feather provides binary columnar serialization for data frames.
It is designed to make reading and writing data frames efficient,
and to make sharing data across data analysis languages easy.
\code{\link[=write_feather]{write_feather()}} can write both the Feather Version 1 (V1),
a legacy version available starting in 2016, and the Version 2 (V2),
which is the Apache Arrow IPC file format.
The default version is V2.
V1 files are distinct from Arrow IPC files and lack many features,
such as the ability to store all Arrow data tyeps, and compression support.
\code{\link[=write_ipc_file]{write_ipc_file()}} can only write V2 files.
}
\examples{
# We recommend the ".arrow" extension for Arrow IPC files (Feather V2).
tf1 <- tempfile(fileext = ".feather")
tf2 <- tempfile(fileext = ".arrow")
tf3 <- tempfile(fileext = ".arrow")
on.exit({
  unlink(tf1)
  unlink(tf2)
  unlink(tf3)
})
write_feather(mtcars, tf1, version = 1)
write_feather(mtcars, tf2)
write_ipc_file(mtcars, tf3)
}
\seealso{
\link{RecordBatchWriter} for lower-level access to writing Arrow IPC data.

\link{Schema} for information about schemas and metadata handling.
}
