% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{read_json_arrow}
\alias{read_json_arrow}
\title{Read a JSON file}
\usage{
read_json_arrow(file, col_select = NULL, as_tibble = TRUE, ...)
}
\arguments{
\item{file}{A character path to a local file, or an Arrow input stream}

\item{col_select}{A \link[tidyselect:vars_select]{tidy selection specification}
of columns, as used in \code{dplyr::select()}.}

\item{as_tibble}{Should the function return a \code{data.frame} or an
\link[=arrow__Table]{arrow::Table}?}

\item{...}{Additional options, passed to \code{json_table_reader()}}
}
\value{
A \code{data.frame}, or an \code{arrow::Table} if \code{as_tibble = FALSE}.
}
\description{
Use \link[=arrow__json__TableReader]{arrow::json::TableReader} from \code{\link[=json_table_reader]{json_table_reader()}}
}
\examples{
\donttest{
try({
  tf <- tempfile()
  on.exit(unlink(tf))
  writeLines('
    { "hello": 3.5, "world": false, "yo": "thing" }
    { "hello": 3.25, "world": null }
    { "hello": 0.0, "world": true, "yo": null }
  ', tf, useBytes=TRUE)
  df <- read_json_arrow(tf)
})
}
}
