% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\name{npermutations}
\alias{npermutations}
\title{Number of permutations}
\usage{
npermutations(x = NULL, k = n, n = NULL, v = NULL, freq = NULL,
  replace = FALSE, bigz = FALSE)
}
\arguments{
\item{x}{an integer or a vector, will be treated as \code{n} if integer; otherwise, will be treated as \code{v}}

\item{k}{an integer, the number of items drawn}

\item{n}{an integer, the total number of items, its actual value may be determined by other variables}

\item{v}{a vector to be drawn}

\item{freq}{an integer vector of item repeat frequencies}

\item{replace}{an logical to draw items with replacement}

\item{bigz}{an logical to indicate using \link[gmp:bigz]{gmp::bigz}}
}
\description{
Number of permutations
}
\examples{
npermutations(7)
npermutations(LETTERS[1:5])
npermutations(5, 2)
npermutations(LETTERS, k = 5)

# integer overflow
\dontrun{npermutations(14, 10)}
npermutations(14, 10, bigz = TRUE)

# number of permutations of `c("a", "b", "b")`
# they are `c("a", "b")`, `c("b", "b")` and `c("b", "b")`
npermutations(k = 2, freq = c(1, 2))

# zero sized partitions
npermutations(0)
npermutations(5, 0)
npermutations(5, 6)
npermutations(0, 1)
npermutations(0, 0)
}
\seealso{
\link{permutations} for generating all permutations and \link{ipermutations} for iterating permutations
}
