% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/2_SimpleModels.R
\name{M_M_1_K}
\alias{M_M_1_K}
\title{Obtains the main characteristics of a M/M/1/K queueing model}
\usage{
M_M_1_K(lambda = 3, mu = 6, k = 2)
}
\arguments{
\item{lambda}{Mean arrival rate}

\item{mu}{Mean service rate}

\item{k}{Maximun size of the queue}
}
\value{
Returns the next information of a M/M/1/K model:
\item{rho}{Constant coefficient: \eqn{\lambda/\rho}}
\item{barrho}{Traffic intensity: \ifelse{latex}{\eqn{\bar{\rho}}}{\out{<i>&#862;&rho;</i>}}}
\item{barlambda}{Effective arrival rate: \ifelse{latex}{\eqn{\bar{\lambda}}}{\out{<i>&#862;&lambda;</i>}}}
\item{l}{Mean number of customers in the system: \eqn{L}}
\item{lq}{Mean number of customers in the queue: \ifelse{latex}{\eqn{L_{q}}}{\out{<i>L<sub>q</sub></i>}}}
\item{w}{Waiting time in the system: \eqn{W}}
\item{wq}{Waiting time in the queue: \ifelse{latex}{\eqn{W_{q}}}{\out{<i>W<sub>q</sub></i>}}}
\item{eff}{Efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_q)}}{\out{<i>Eff = W/(W-W<sub>q</sub></i>)}}}
}
\description{
Obtains the main characteristics of a M/M/1/K queueing model
}
\examples{
#A workstation with a single processor
#runs programs with CPU time following
#an exponential distribution with mean 3 minutes.
#The programs arrive to the workstation following
#a Poisson process with an intensity of 15
#programs for hour.
#The workstation has a limited memory and only
#one program is allowed to wait if the processor
#is busy.

M_M_1_K(lambda=15, mu=60/3, k=1)
}
\seealso{
Other AnaliticalModels: \code{\link{ClosedJacksonNetwork}};
  \code{\link{M_M_1_INF_H}}; \code{\link{M_M_1}};
  \code{\link{M_M_INF}}; \code{\link{M_M_S_INF_H_Y}};
  \code{\link{M_M_S_INF_H}}; \code{\link{M_M_S_K}};
  \code{\link{M_M_S}}; \code{\link{OpenJacksonNetwork}}
}

