% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{confidence_binomial}
\alias{confidence_binomial}
\alias{confidence_binomial-method}
\alias{confidence_binomial,numeric-method}
\title{Confidence Interval for Binomial Proportions}
\usage{
confidence_binomial(object, ...)

\S4method{confidence_binomial}{numeric}(
  object,
  n,
  level = 0.95,
  method = "wald",
  corrected = FALSE
)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector giving the number of success.}

\item{...}{Currently not used.}

\item{n}{A length-one \code{\link{numeric}} vector giving the number of trials.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.
Must be a single number between \eqn{0} and \eqn{1}.}

\item{method}{A \code{\link{character}} string specifying the method to be used.
Any unambiguous substring can be used.}

\item{corrected}{A \code{\link{logical}} scalar: should continuity correction be used?
Only used if \code{method} is "\code{wald}".}
}
\value{
A length-two \code{\link{numeric}} vector giving the lower and upper confidence
limits.
}
\description{
Computes a Wald interval for a proportion at a desired level of significance.
}
\examples{
## Confidence interval for a mean
x <- seq(from = -4, to = 4, by = 0.01)
y <- dnorm(x)

confidence_mean(y, type = "student")
confidence_mean(y, type = "normal")

## Confidence interval for a propotion
confidence_binomial(118, n = 236)

x <- c(35, 74, 22, 69)
confidence_multinomial(x)
}
\seealso{
Other summary statistics: 
\code{\link{confidence_mean}()},
\code{\link{confidence_multinomial}()},
\code{\link{interval_credible}()},
\code{\link{interval_hdr}()}
}
\author{
N. Frerebeau
}
\concept{summary statistics}
